using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

      static void AddHighlightAnnot(CPDF PDF, TAnnotType Type, uint Color, double x, double y, String Text, String Subject, String Comment)
      {
         double w = PDF.GetTextWidth(Text);
         PDF.WriteText(x, y, Text);
         PDF.HighlightAnnot(Type, x, y + PDF.GetDescent(), w, 20.0, Color, "Test app", Subject, Comment);
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
            int i, a;
            double y = 50.0;
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            pdf.CreateNewPDF(null);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();
               pdf.SetFont("Helvetica", TFStyle.fsRegular, 20.0, false, TCodepage.cp1252);
               AddHighlightAnnot(pdf, TAnnotType.atHighlight, CPDF.PDF_YELLOW,  50.0, y, "Highlight Annotation", "Highlight Annotations", "This is a highlight annotation");
               AddHighlightAnnot(pdf, TAnnotType.atSquiggly,  CPDF.PDF_RED,    300.0, y, "Squiggly Annotation",  "Highlight Annotations", "This is a squiggly annotation");
               y += 30.0;
               AddHighlightAnnot(pdf, TAnnotType.atStrikeOut, CPDF.PDF_RED,     50.0, y, "Strikeout Annotation",  "Highlight Annotations", "This is a strikeout annotation");
               AddHighlightAnnot(pdf, TAnnotType.atUnderline, CPDF.PDF_RED,    300.0, y, "Underline Annotation",  "Highlight Annotations", "This is a underline annotation");

               y += 40.0;
               pdf.CircleAnnot( 50.0, y, 200.0, 100.0, 1.0, CPDF.PDF_CREAM, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Circle Annotations", "This is a circle annotation");
               pdf.SquareAnnot(300.0, y, 200.0, 100.0, 1.0, CPDF.PDF_CREAM, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Square Annotations", "This is a square annotation");

               y += 130.0;
               pdf.ChangeFontSize(12.0);
               pdf.WriteFTextEx(50.0, y, pdf.GetPageWidth() - 100.0, -1.0, TTextAlign.taLeft, "The icon color of text and file attachment annotations can be changed if "+
                               "necessary with SetAnnotColor(). The background color must be set.\n\nText Annotations:");

               y = pdf.GetPageHeight() - pdf.GetLastTextPosY() + 10.0;
               // The default icon color can be changed if necessary
               pdf.TextAnnot(50.0, y, 200.0, 100.0, "Test app", "This is a text annotation", TAnnotIcon.aiComment, false);
               a = pdf.TextAnnot(100.0, y, 200.0, 100.0, "Test app", "This is a text annotation", TAnnotIcon.aiHelp, false);
               pdf.SetAnnotColor(a, TAnnotColor.acBackColor, TPDFColorSpace.csDeviceRGB, pdf.RGB(200, 20, 30));

               pdf.TextAnnot(150.0, y, 200.0, 100.0, "Test app", "This is a text annotation", TAnnotIcon.aiInsert, false);
               a = pdf.TextAnnot(200.0, y, 200.0, 100.0, "Test app", "This is a text annotation", TAnnotIcon.aiKey, false);
               pdf.SetAnnotColor(a, TAnnotColor.acBackColor, TPDFColorSpace.csDeviceRGB, pdf.RGB(50, 200, 30));
               pdf.TextAnnot(250.0, y, 200.0, 100.0, "Test app", "This is a text annotation", TAnnotIcon.aiNewParagraph, false);
               a = pdf.TextAnnot(300.0, y, 200.0, 100.0, "Test app", "This is a text annotation", TAnnotIcon.aiNote, false);
               pdf.SetAnnotColor(a, TAnnotColor.acBackColor, TPDFColorSpace.csDeviceRGB, pdf.RGB(70, 120, 210));
               pdf.TextAnnot(350.0, y, 200.0, 100.0, "Test app", "This is a text annotation", TAnnotIcon.aiParagraph, false);

               y += 50.0;
               pdf.WriteText(50.0, y, "File Attachment Annotations:");

               y += 20.0;
               String filePath = "../../../../test_files/gdi.emf";
               pdf.FileAttachAnnot( 50.0, y, TFileAttachIcon.faiGraph,     "Test app", "An example attachment", filePath, true);
               pdf.FileAttachAnnot(100.0, y, TFileAttachIcon.faiPaperClip, "Test app", "An example attachment", filePath, true);
               a = pdf.FileAttachAnnot(150.0, y, TFileAttachIcon.faiPushPin,   "Test app", "An example attachment", filePath, true);
               pdf.SetAnnotColor(a, TAnnotColor.acBackColor, TPDFColorSpace.csDeviceRGB, pdf.RGB(70, 120, 210));
               pdf.FileAttachAnnot(200.0, y, TFileAttachIcon.faiTag,       "Test app", "An example attachment", filePath, true);

               y += 60.0;
               a = pdf.FreeTextAnnot(50.0, y, 200.0, 80.0, "Test app", "This is a FreeText Annotation.", TTextAlign.taCenter);
               pdf.SetAnnotBorderWidth(a, 3.0);
               pdf.SetAnnotColor(a, TAnnotColor.acBorderColor, TPDFColorSpace.csDeviceRGB, CPDF.PDF_GRAY);

               a = pdf.FreeTextAnnot(400.0, y, 150.0, 45.0, "Test app", "This is a FreeText Callout Annotation with a cloudy border.", TTextAlign.taCenter);
               pdf.SetAnnotBorderWidth(a, 2.0);
               pdf.SetAnnotColor(a, TAnnotColor.acBorderColor, TPDFColorSpace.csDeviceRGB, CPDF.PDF_RED);
               pdf.SetAnnotBorderEffect(a, TBorderEffect.beCloudy1);
               pdf.ConvToFreeTextCallout(a, 300.0f, (float)y + 40.0f, 30.0f, TLineEndStyle.leOpenArrow);

               y += 120.0;
               pdf.WriteText(50.0, y, "Line Annotations:");

               y += 30.0; pdf.LineAnnot(50.0, y, 350.0, y, 1.0, TLineEndStyle.leNone,         TLineEndStyle.leNone, CPDF.PDF_RED, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
               y += 20.0; pdf.LineAnnot(50.0, y, 350.0, y, 1.0, TLineEndStyle.leButt,         TLineEndStyle.leButt, CPDF.PDF_RED, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
               y += 20.0; pdf.LineAnnot(50.0, y, 350.0, y, 1.0, TLineEndStyle.leCircle,       TLineEndStyle.leCircle, CPDF.PDF_RED, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
               y += 20.0; pdf.LineAnnot(50.0, y, 350.0, y, 1.0, TLineEndStyle.leClosedArrow,  TLineEndStyle.leClosedArrow, CPDF.PDF_RED, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
               y += 20.0; pdf.LineAnnot(50.0, y, 350.0, y, 1.0, TLineEndStyle.leRClosedArrow, TLineEndStyle.leRClosedArrow, CPDF.PDF_RED, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
               y += 20.0; pdf.LineAnnot(50.0, y, 350.0, y, 1.0, TLineEndStyle.leDiamond,      TLineEndStyle.leDiamond, CPDF.PDF_RED, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
               y += 20.0; pdf.LineAnnot(50.0, y, 350.0, y, 1.0, TLineEndStyle.leOpenArrow,    TLineEndStyle.leOpenArrow, CPDF.PDF_RED, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
               y += 20.0; pdf.LineAnnot(50.0, y, 350.0, y, 1.0, TLineEndStyle.leROpenArrow,   TLineEndStyle.leROpenArrow, CPDF.PDF_RED, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
               y += 20.0; pdf.LineAnnot(50.0, y, 350.0, y, 1.0, TLineEndStyle.leSlash,        TLineEndStyle.leSlash, CPDF.PDF_RED, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");
               y += 20.0; pdf.LineAnnot(50.0, y, 350.0, y, 1.0, TLineEndStyle.leSquare,       TLineEndStyle.leSquare, CPDF.PDF_RED, CPDF.PDF_BLACK, TPDFColorSpace.csDeviceRGB, "Test app", "Line Annotations", "This is a line annotation");

            pdf.EndPage();

            pdf.Append();

               TFltPoint[] points = new TFltPoint[5];
               points[0] = new TFltPoint(50.0f, 200.0f);
               points[1] = new TFltPoint(50.0f, 100.0f);
               points[2] = new TFltPoint(150.0f, 50.0f);
               points[3] = new TFltPoint(250.0f, 100.0f);
               points[4] = new TFltPoint(250.0f, 200.0f);

               pdf.PolyLineAnnot(points, 1.0, TLineEndStyle.leDiamond, TLineEndStyle.leCircle, CPDF.PDF_WHITE, CPDF.PDF_RED, TPDFColorSpace.csDeviceRGB, "Test app", "Polyline Annotations", "This is a polyline annotation");

               for (i = 0; i < points.Length; i++)
                  points[i].x += 250.0f;

               pdf.PolygonAnnot(points, 1.0, CPDF.PDF_CREAM, CPDF.PDF_RED, TPDFColorSpace.csDeviceRGB, "Test app", "Polygon Annotations", "This is a polygon annotation");

               for (i = 0; i < points.Length; i++)
               {
                  points[i].x -= 250.0f;
                  points[i].y += 230.0f;
               }

               y = 230.0;
               pdf.SetFont("Helvetica", TFStyle.fsRegular, 12.0, false, TCodepage.cp1252);
               pdf.WriteFTextEx(50.0, y, pdf.GetPageWidth() - 100.0f, -1.0, TTextAlign.taLeft, "The points of an Ink Annotation will be approximated with bezier curves."+
                  "The result is a smooth path. A polyline annotation is almost the same annotation type without the approximation with bezier curves.");

               pdf.InkAnnot(points, 1.0, CPDF.PDF_BLUE, TPDFColorSpace.csDeviceRGB, "Test app", "Ink Annotations", "This is an ink annotation");

               y+= 230.0;
               pdf.WriteText(50.0, y, "Stamp Annotations:");
               y += 20.0;
               pdf.WriteFTextEx(50.0, y, pdf.GetPageWidth() - 100.0, -1.0, TTextAlign.taLeft, "The default color of a stamp annotation can be changed with SetAnnotColor(). The border or text color must be set.");

               y = pdf.GetPageHeight() - pdf.GetLastTextPosY() + 10.0;
               pdf.StampAnnot(TRubberStamp.rsApproved,             50.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
               pdf.StampAnnot(TRubberStamp.rsAsIs,                220.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
               pdf.StampAnnot(TRubberStamp.rsConfidential,        390.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");

               y += 60.0;
               pdf.StampAnnot(TRubberStamp.rsDepartmental,         50.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
               pdf.StampAnnot(TRubberStamp.rsDraft,               220.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
               pdf.StampAnnot(TRubberStamp.rsExperimental,        390.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");

               y += 60.0;
               pdf.StampAnnot(TRubberStamp.rsExpired,              50.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
               a = pdf.StampAnnot(TRubberStamp.rsFinal,            220.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
               pdf.SetAnnotColor(a, TAnnotColor.acBorderColor, TPDFColorSpace.csDeviceRGB, pdf.RGB(170, 10, 160));
               pdf.StampAnnot(TRubberStamp.rsForComment,          390.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");

               y += 60.0;
               pdf.StampAnnot(TRubberStamp.rsForPublicRelease,     50.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
               pdf.StampAnnot(TRubberStamp.rsNotApproved,         220.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
               pdf.StampAnnot(TRubberStamp.rsNotForPublicRelease, 390.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");

               y += 60.0;
               pdf.StampAnnot(TRubberStamp.rsSold,                 50.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");
               pdf.StampAnnot(TRubberStamp.rsTopSecret,           220.0, y, 150.0, 50.0, "Test app", "Stamp Annotations", "This is a stamp annotation");

            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               filePath = Directory.GetCurrentDirectory();
               filePath += "\\out.pdf.";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
